<?php

class Service extends Controller
{

    public function view()
    {

        $dataView['current'] = "service";
        /******* end header code *******/
        $id = (int)$this->loadRoute()->getSegment(2);
        if ($id == 0) {
            $this->redirect("error", "index");
            exit();
        }
        // get  data
        $dataView['service'] = $this->loadModel("ServiceModel")->retrieveAllData("WHERE `id` =? AND `status` =? AND `deleted` =?", array($id, 1, 1));
        if (!is_array($dataView['service'])) {
            $this->redirect("error", "index");
            exit();
        }
        $dataView['service'] = array_shift($dataView['service']);

        // set page title
        $dataView['title'] = "بيرفكت هيلث |  " . $dataView['service']['title'];
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "service_details";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function SendMessageForm()
    {
        if (isset($_POST['action']) && $_POST['action'] == "addsentmessagedata") {
            // preparing validation array
            $validationArray = array(
                "name_data" => array(
                    "value" => $this->loadSecurity($_POST['name'])->clear(),
                    "errorName" => "الاسم ",
                    "rules" => "required|min-length[1]"
                ),
                "phone_data" => array(
                    "value" => $this->loadSecurity($_POST['phone'])->clear(),
                    "errorName" => "رقم الهاتف",
                    "rules" => "required|number|min-length[1]"
                ),
                "email_data" => array(
                    "value" => $this->loadSecurity($_POST['email'])->clear(),
                    "errorName" => "الايميل",
                    "rules" => "required|min-length[1]"
                ),

                "message_data" => array(
                    "value" => $this->loadSecurity($_POST['message'])->clear(),
                    "errorName" => " الرساله",
                    "rules" => "required|min-length[1]"
                ),
            );
            // load validation class and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                $datToModel['name'] = $dataValid['success']['name_data'];
                $datToModel['phone'] = $dataValid['success']['phone_data'];
                $datToModel['mail'] = $dataValid['success']['email_data'];
                $datToModel['message'] = $dataValid['success']['message_data'];
                $datToModel['created'] = time();
                $add = $this->loadModel("UserMessageModel", $datToModel)->add();
                if (FALSE !== $add) {
                    $data['status'] = "success";
                    $data['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i>  نجاح </strong> تم  اضافه البيانات بنجاح ... </div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                } else {
                    $data['status'] = "failed";
                    $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> خطا ! </strong> خطا في اضافه البيانات برجاء المحاوله مره اخري ....</div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                }

            } else {
                $data['status'] = "failed";
                $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> خطا ! </strong> ' . $dataValid . '</div>';
                echo $this->loadAjax()->DataToJson($data);
                exit();
            }

        }
    }


}

?>
